



/**
 ******************************************************************************
 *
 * @file        BSP_Common_MG04_06.h
 * @brief       
 
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#ifndef _BSP_COMMON_MG04_06_H
#define _BSP_COMMON_MG04_06_H
 
 
#include "MG32.h"
#include "MG32__Common_DRV.h"
#include "MG32_GPIO_DRV.h" 
#include "MG32_ADC_DRV.h"


/**
 * @name  Define
 */
///@{

// DMA
#define DMA_MAX_SIZE                  65535                                            /*!< DMA max size in one time. (refer to MG32F02V032 spec)*/
                                                                                               
#define DMA_LCD_INChannel             DMAChannel0                                      /*!< LCD DMA channel is channel0*/
#define DMA_LCD_INFlag                DMA_FLAG_CH0_TCF                                 /*!< Define LCD DMA complete flag.*/
                                                                                       
#define DMA_Flash_INChannel           DMAChannel1                                      /*!< Flash IN DMA channel is channel1*/
#define DMA_Flash_INFlag              DMA_FLAG_CH1_TCF                                 /*!< Flash IN DMA complete flag.*/
                                                                                       
#define DMA_ASB_OUTChannel            DMAChannel2                                      /*!< Flash OUT DMA channel is channel2*/
#define DMA_ASB_OUTFlag               DMA_FLAG_CH2_TCF                                 /*!< Flash OUT DMA complete flag.*/
                                      
//ADC                                 
#define MG04_06_ADC                   ADC0
          
#define __BSP_ADC_ENABLE()            MG04_06_ADC->CR0.MBIT.EN = ENABLE          
#define __BSP_ADC_START_SW()          MG04_06_ADC->START.W |= ADC_START_START_mask_w   /*!<Software start ADC conversion.*/
#define __BSP_ADC_GETDATA()           ((int16_t)MG04_06_ADC->DAT0.H[0])
#define __BSP_ADC_CLEARFLAG(__FLAG__) MG04_06_ADC->STA.W = (__FLAG__)
#define __BSP_ADC_EXCHANNEL(__CH__)   MG04_06_ADC->START.B[1] = (__CH__)

///@}
 
/**
 * @name  Typedef
 */
///@{



/*! @enum   PINX_Mode_TypeDef
    @brief  Pin IO mode control options .
*/
typedef enum
{
    Analog_Mode          = 0,       /*!< Analog IO*/
    Data_DIR_OUT_QB      = 1,       /*!< Qusi-bidirection output*/
    Data_DIR_OUT_OD_NoRU = 2,       /*!< Open drain output and disable internal pull-up resistance*/
    Data_DIR_OUT_OD_RU   = 3,       /*!< Open drain output with internal pull-up resistance*/
    Data_DIR_OUT_PP      = 4,       /*!< Push pull output.*/
    Data_DIR_IN_NoRU     = 5,       /*!< Digital input and disable internal pull-up resistance.*/
    Data_DIR_IN_RU       = 6,       /*!< Digital input with internal pull up resistance*/
    
}GPIO_Mode_TypeDef;




//@}



/**
 * @name  function
 */
///@{

void BSP_GPIO_PinConfig(Pin_Struct* PinName , GPIO_Mode_TypeDef PinMode , uint8_t PinAFS);

uint32_t BSP_GetTick(void);
void BSP_IncTick(void);
void BSP_Delay( uint32_t BSP_DelayTime);

void BSP_Init(void);
void BSP_InitCallback(void);

///@}
 
#endif




